<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

session_start();
require_once 'db.php';

// セッションチェック
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("Location: login.php");
    exit;
}

// 期間指定
$start_date = $_GET['start_date'] ?? '';
$end_date = $_GET['end_date'] ?? '';

// デリバリー対象テーブル
$delivery_tables = "(999, 888, 777)";
$delivery_category = 10;

// ▼ 日別メニュー売上（最新30件）
$sql_daily = "
    SELECT 
        DATE(o.created_at) AS date,
        o.table_id,
        m.name AS menu_name,
        SUM(oi.quantity) AS total_quantity,
        SUM(oi.subtotal) AS total_sales
    FROM orderitems oi
    JOIN menuitems m ON oi.menu_item_id = m.id
    JOIN orders o ON oi.order_id = o.id
    WHERE o.table_id IN $delivery_tables
      AND m.category_id = :delivery_category
    GROUP BY DATE(o.created_at), o.table_id, m.name
    ORDER BY DATE(o.created_at) DESC, o.table_id ASC
    LIMIT 30
";
$stmt = $pdo->prepare($sql_daily);
$stmt->execute([':delivery_category' => $delivery_category]);
$daily = $stmt->fetchAll();

// ▼ 月別集計
$sql_monthly = "
    SELECT 
        DATE_FORMAT(o.created_at, '%Y-%m') AS month,
        o.table_id,
        m.name AS menu_name,
        SUM(oi.quantity) AS total_quantity,
        SUM(oi.subtotal) AS total_sales
    FROM orderitems oi
    JOIN menuitems m ON oi.menu_item_id = m.id
    JOIN orders o ON oi.order_id = o.id
    WHERE o.table_id IN $delivery_tables
      AND m.category_id = :delivery_category
    GROUP BY month, o.table_id, m.name
    ORDER BY month DESC, o.table_id ASC, m.name ASC
";
$stmt = $pdo->prepare($sql_monthly);
$stmt->execute([':delivery_category' => $delivery_category]);
$monthly = $stmt->fetchAll();

// ▼ 指定期間
$period = [];
if ($start_date && $end_date) {
    $sql_period = "
        SELECT 
            o.table_id,
            m.name AS menu_name,
            SUM(oi.quantity) AS total_quantity,
            SUM(oi.subtotal) AS total_sales
        FROM orderitems oi
        JOIN menuitems m ON oi.menu_item_id = m.id
        JOIN orders o ON oi.order_id = o.id
        WHERE o.table_id IN $delivery_tables
          AND m.category_id = :delivery_category
          AND DATE(o.created_at) BETWEEN :start AND :end
        GROUP BY o.table_id, m.name
        ORDER BY o.table_id ASC, total_sales DESC
    ";
    $stmt = $pdo->prepare($sql_period);
    $stmt->execute([
        ':delivery_category' => $delivery_category,
        ':start' => $start_date,
        ':end' => $end_date
    ]);
    $period = $stmt->fetchAll();

    $period_total = 0;
    foreach ($period as $row) {
        $period_total += $row['total_sales'];
    }
}

// ▼ デリバリー全体：日別売上
$sql_shop_daily = "
    SELECT 
        DATE(o.created_at) AS date,
        SUM(o.total_price) AS total_sales
    FROM orders o
    WHERE o.table_id IN $delivery_tables
    GROUP BY DATE(o.created_at)
    ORDER BY DATE(o.created_at) DESC
";
$shop_daily = $pdo->query($sql_shop_daily)->fetchAll();

// ▼ デリバリー全体：月別売上
$sql_shop_monthly = "
    SELECT 
        DATE_FORMAT(o.created_at, '%Y-%m') AS month,
        SUM(o.total_price) AS total_sales
    FROM orders o
    WHERE o.table_id IN $delivery_tables
    GROUP BY month
    ORDER BY month DESC
";
$shop_monthly = $pdo->query($sql_shop_monthly)->fetchAll();
?>

<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="UTF-8">
    <title>Delivery Sales Report</title>
    <link rel="stylesheet" href="style.css">
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
            margin-top: 30px;
        }

        th, td {
            padding: 10px;
            border: 1px solid #ccc;
            text-align: center;
        }

        th {
            background-color: #007BFF;
            color: white;
        }

        h2, h3 {
            text-align: center;
        }

        form {
            text-align: center;
            margin-bottom: 20px;
        }

        input[type="date"] {
            padding: 6px;
            margin: 0 5px;
        }

        .btn {
            background-color: #4CAF50;
            color: white;
            padding: 8px 15px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            margin-bottom: 20px;
        }

        .btn:hover {
            background-color: #388e3c;
        }
    </style>
</head>
<body>
<div class="sales-container">

    <h2>Delivery Sales Report</h2>
    <a href="delivery_shop_sales.php" class="btn period_btn">View Delivery Store-wide Sales</a>
    <a href="dashboard.php" class="btn">Back to Dashboard</a>

    <h3>Sales in Specified Period (Delivery)</h3>
    <form method="GET">
        <label>Start Date: <input type="date" name="start_date" value="<?= htmlspecialchars($start_date) ?>"></label>
        <label>End Date: <input type="date" name="end_date" value="<?= htmlspecialchars($end_date) ?>"></label>
        <?php if ($start_date && $end_date): ?>
            <table>
                <tr>
                    <th>Table</th><th>Menu Item</th><th>Total Quantity</th><th>Total Sales (AED)</th>
                </tr>
                <?php foreach ($period as $row): ?>
                <tr>
                    <td><?= htmlspecialchars($row['table_id']) ?></td>
                    <td><?= htmlspecialchars($row['menu_name']) ?></td>
                    <td><?= $row['total_quantity'] ?></td>
                    <td><?= number_format($row['total_sales']) ?></td>
                </tr>
                <?php endforeach; ?>
                <!-- 合計行 -->
                <tr style="background-color: #f1f1f1; font-weight: bold;">
                    <td colspan="3">Total Sales in Period</td>
                    <td><?= number_format($period_total) ?> AED</td>
                </tr>
            </table>
        <?php endif; ?>
        <button type="submit" class="period_btn">Show</button>
    </form>

    <!-- CSVダウンロードボタン -->
    <form method="get" action="export_sales_csv.php">
        <input type="hidden" name="start_date" value="<?= htmlspecialchars($start_date) ?>">
        <input type="hidden" name="end_date" value="<?= htmlspecialchars($end_date) ?>">
        <button type="submit" class="csv_btn">Download CSV (Period)</button>
    </form>

    <h3>Daily Menu Sales (Delivery)</h3>
    <table>
        <tr>
            <th>Date</th><th>Table</th><th>Menu Item</th><th>Quantity</th><th>Sales (AED)</th>
        </tr>
        <?php foreach ($daily as $row): ?>
        <tr>
            <td><?= htmlspecialchars($row['date']) ?></td>
            <td><?= htmlspecialchars($row['table_id']) ?></td>
            <td><?= htmlspecialchars($row['menu_name']) ?></td>
            <td><?= $row['total_quantity'] ?></td>
            <td><?= number_format($row['total_sales']) ?></td>
        </tr>
        <?php endforeach; ?>
    </table>

    <h3>Monthly Sales (Delivery)</h3>
    <table>
        <tr>
            <th>Month</th><th>Table</th><th>Menu Item</th><th>Quantity</th><th>Sales (AED)</th>
        </tr>
        <?php foreach ($monthly as $row): ?>
        <tr>
            <td><?= htmlspecialchars($row['month']) ?></td>
            <td><?= htmlspecialchars($row['table_id']) ?></td>
            <td><?= htmlspecialchars($row['menu_name']) ?></td>
            <td><?= $row['total_quantity'] ?></td>
            <td><?= number_format($row['total_sales']) ?></td>
        </tr>
        <?php endforeach; ?>
    </table>

    <h3>Store-wide Daily Sales (Delivery)</h3>
    <table>
        <tr>
            <th>Date</th><th>Total Sales (AED)</th>
        </tr>
        <?php foreach ($shop_daily as $row): ?>
        <tr>
            <td><?= htmlspecialchars($row['date']) ?></td>
            <td><?= number_format($row['total_sales']) ?></td>
        </tr>
        <?php endforeach; ?>
    </table>

    <h3>Store-wide Monthly Sales (Delivery)</h3>
    <table>
        <tr>
            <th>Month</th><th>Total Sales (AED)</th>
        </tr>
        <?php foreach ($shop_monthly as $row): ?>
        <tr>
            <td><?= htmlspecialchars($row['month']) ?></td>
            <td><?= number_format($row['total_sales']) ?></td>
        </tr>
        <?php endforeach; ?>
    </table>

</div>
</body>
</html>
