<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

session_start();
require_once 'db.php';

if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("Location: login.php");
    exit;
}

// 🔹 対象となるデリバリーテーブルID
$delivery_tables = "(999, 888, 777)";

// ▼ デリバリー：日別売上
$sql_shop_daily = "
    SELECT 
        DATE(created_at) AS date,
        SUM(total_price) AS total_sales
    FROM orders
    WHERE table_id IN $delivery_tables
    GROUP BY DATE(created_at)
    ORDER BY DATE(created_at) DESC
";
$shop_daily = $pdo->query($sql_shop_daily)->fetchAll();

// ▼ デリバリー：月別売上
$sql_shop_monthly = "
    SELECT 
        DATE_FORMAT(created_at, '%Y-%m') AS month,
        SUM(total_price) AS total_sales
    FROM orders
    WHERE table_id IN $delivery_tables
    GROUP BY month
    ORDER BY month DESC
";
$shop_monthly = $pdo->query($sql_shop_monthly)->fetchAll();

// ▼ 日別合計
$total_shop_daily = 0;
foreach ($shop_daily as $row) {
    $total_shop_daily += $row['total_sales'];
}

// ▼ 月別合計
$total_shop_monthly = 0;
foreach ($shop_monthly as $row) {
    $total_shop_monthly += $row['total_sales'];
}
?>

<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="UTF-8">
    <title>Delivery Store-wide Sales</title>
    <link rel="stylesheet" href="style.css">
    <style>
        .sales-container {
            max-width: 1000px;
            margin: auto;
            padding: 30px;
        }

        h2, h3 {
            text-align: center;
            margin-top: 40px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }

        th, td {
            padding: 10px;
            border: 1px solid #ccc;
            text-align: center;
        }

        th {
            background-color: #007BFF;
            color: white;
        }

        .btn {
            display: inline-block;
            background-color: #4CAF50;
            color: white;
            padding: 8px 15px;
            border: none;
            border-radius: 5px;
            text-decoration: none;
            margin-bottom: 20px;
        }

        .btn:hover {
            background-color: #388e3c;
        }

        .csv_btn {
            display: inline-block;
            background-color: #FF9800;
            color: white;
            padding: 8px 15px;
            border: none;
            border-radius: 5px;
            text-decoration: none;
            margin-left: 10px;
        }

        .csv_btn:hover {
            background-color: #e68900;
        }
    </style>
</head>
<body>
<div class="sales-container">

    <h2>Delivery Store-wide Sales</h2>
    <a href="delivery_sales_report.php" class="btn">← Back to Delivery Sales Report</a>
    <a href="export_delivery_shop_csv.php" class="csv_btn">Download Delivery Sales CSV</a>

    <h3>🏠 Daily Delivery Sales</h3>
    <table>
        <tr>
            <th>Date</th><th>Total Sales (AED)</th>
        </tr>
        <?php foreach ($shop_daily as $row): ?>
        <tr>
            <td><?= htmlspecialchars($row['date']) ?></td>
            <td><?= number_format($row['total_sales']) ?></td>
        </tr>
        <?php endforeach; ?>
        <tr style="background-color: #f1f1f1; font-weight: bold;">
          <td>Daily Sales Total</td>
          <td><?= number_format($total_shop_daily) ?> AED</td>
        </tr>
    </table>

    <h3>📆 Monthly Delivery Sales</h3>
    <table>
        <tr>
            <th>Month</th><th>Total Sales (AED)</th>
        </tr>
        <?php foreach ($shop_monthly as $row): ?>
        <tr>
            <td><?= htmlspecialchars($row['month']) ?></td>
            <td><?= number_format($row['total_sales']) ?></td>
        </tr>
        <?php endforeach; ?>
        <tr style="background-color: #f1f1f1; font-weight: bold;">
          <td>Monthly Sales Total</td>
          <td><?= number_format($total_shop_monthly) ?> AED</td>
        </tr>
    </table>
</div>
</body>
</html>
