<?php
session_start();
require_once 'db.php';

if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("Location: login.php");
    exit;
}

// 期間指定
$start_date = $_GET['start_date'] ?? '';
$end_date = $_GET['end_date'] ?? '';

// ▼ 日別メニュー売上（最新30件）
$sql_daily = "
    SELECT 
        DATE(o.created_at) AS date,
        c.name AS category_name,
        m.name AS menu_name,
        SUM(o.quantity) AS total_quantity,
        SUM(o.subtotal) AS total_sales
    FROM orderitems o
    JOIN menuitems m ON o.menu_item_id = m.id
    LEFT JOIN categories c ON m.category_id = c.id
    GROUP BY DATE(o.created_at), c.name, m.name
    ORDER BY DATE(o.created_at) DESC
    LIMIT 30
";
$daily = $pdo->query($sql_daily)->fetchAll();

// ▼ 月別集計
$sql_monthly = "
    SELECT 
        DATE_FORMAT(o.created_at, '%Y-%m') AS month,
        c.name AS category_name,
        m.name AS menu_name,
        SUM(o.quantity) AS total_quantity,
        SUM(o.subtotal) AS total_sales
    FROM orderitems o
    JOIN menuitems m ON o.menu_item_id = m.id
    LEFT JOIN categories c ON m.category_id = c.id
    GROUP BY month, c.name, m.name
    ORDER BY month DESC, c.name ASC, m.name ASC
";
$monthly = $pdo->query($sql_monthly)->fetchAll();

// ▼ 指定期間：メニュー別売上（メニュー名でまとめて合計）
$period = [];
if ($start_date && $end_date) {
    $sql_period = "
        SELECT 
            c.name AS category_name,
            m.name AS menu_name,
            SUM(o.quantity) AS total_quantity,
            SUM(o.subtotal) AS total_sales
        FROM orderitems o
        JOIN menuitems m ON o.menu_item_id = m.id
        LEFT JOIN categories c ON m.category_id = c.id
        WHERE DATE(o.created_at) BETWEEN :start AND :end
        GROUP BY c.name, m.name
        ORDER BY total_sales DESC
    ";
    $stmt = $pdo->prepare($sql_period);
    $stmt->execute([
        ':start' => $start_date,
        ':end' => $end_date
    ]);
    $period = $stmt->fetchAll();

    // 合計売上を計算
    $period_total = 0;
    foreach ($period as $row) {
        $period_total += $row['total_sales'];
    }
}

// ▼ お店全体：日別売上
$sql_shop_daily = "
    SELECT 
        DATE(created_at) AS date,
        SUM(total_price) AS total_sales
    FROM orders
    GROUP BY DATE(created_at)
    ORDER BY DATE(created_at) DESC
";
$shop_daily = $pdo->query($sql_shop_daily)->fetchAll();

// ▼ お店全体：月別売上
$sql_shop_monthly = "
    SELECT 
        DATE_FORMAT(created_at, '%Y-%m') AS month,
        SUM(total_price) AS total_sales
    FROM orders
    GROUP BY month
    ORDER BY month DESC
";
$shop_monthly = $pdo->query($sql_shop_monthly)->fetchAll();
?>

<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="UTF-8">
    <title>Sales Report</title>
    <link rel="stylesheet" href="style.css">
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
            margin-top: 30px;
        }

        th, td {
            padding: 10px;
            border: 1px solid #ccc;
            text-align: center;
        }

        th {
            background-color: #007BFF;
            color: white;
        }

        h2, h3 {
            text-align: center;
        }

        form {
            text-align: center;
            margin-bottom: 20px;
        }

        input[type="date"] {
            padding: 6px;
            margin: 0 5px;
        }

        .btn {
            background-color: #4CAF50;
            color: white;
            padding: 8px 15px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            margin-bottom: 20px;
        }

        .btn:hover {
            background-color: #388e3c;
        }
    </style>
</head>
<body>
<div class="sales-container">

    <h2>Sales Report</h2>
    <a href="shop_sales.php" class="btn period_btn">View Store-wide Sales</a>
    <a href="dashboard.php" class="btn">Back to Dashboard</a>

    <h3>Sales in Specified Period</h3>
    <form method="GET">
        <label>Start Date: <input type="date" name="start_date" value="<?= htmlspecialchars($start_date) ?>"></label>
        <label>End Date: <input type="date" name="end_date" value="<?= htmlspecialchars($end_date) ?>"></label>
        <?php if ($start_date && $end_date): ?>
            <table>
                <tr>
                    <th>Category</th><th>Menu Item</th><th>Total Quantity</th><th>Total Sales (AED)</th>
                </tr>
                <?php foreach ($period as $row): ?>
                <tr>
                    <td><?= htmlspecialchars($row['category_name'] ?? '-') ?></td>
                    <td><?= htmlspecialchars($row['menu_name']) ?></td>
                    <td><?= $row['total_quantity'] ?></td>
                    <td><?= number_format($row['total_sales']) ?></td>
                </tr>
                <?php endforeach; ?>
                <!-- 合計行 -->
                <tr style="background-color: #f1f1f1; font-weight: bold;">
                    <td colspan="3">Total Sales in Period</td>
                    <td><?= number_format($period_total) ?> AED</td>
                </tr>
            </table>
        <?php endif; ?>
        <button type="submit" class="period_btn">Show</button>
    </form>

    <!-- CSVダウンロードボタン -->
    <form method="get" action="export_sales_csv.php">
        <input type="hidden" name="start_date" value="<?= htmlspecialchars($start_date) ?>">
        <input type="hidden" name="end_date" value="<?= htmlspecialchars($end_date) ?>">
        <button type="submit" class="csv_btn">Download CSV (Period)</button>
    </form>

    <h3>Daily Menu Sales (Latest 30 Entries)</h3>
    <table>
        <tr>
            <th>Date</th><th>Category</th><th>Menu Item</th><th>Quantity</th><th>Sales (AED)</th>
        </tr>
        <?php foreach ($daily as $row): ?>
        <tr>
            <td><?= htmlspecialchars($row['date']) ?></td>
            <td><?= htmlspecialchars($row['category_name'] ?? '-') ?></td>
            <td><?= htmlspecialchars($row['menu_name']) ?></td>
            <td><?= $row['total_quantity'] ?></td>
            <td><?= number_format($row['total_sales']) ?></td>
        </tr>
        <?php endforeach; ?>
    </table>

    <h3>Monthly Sales</h3>
    <table>
        <tr>
            <th>Month</th><th>Category</th><th>Menu Item</th><th>Quantity</th><th>Sales (AED)</th>
        </tr>
        <?php foreach ($monthly as $row): ?>
        <tr>
            <td><?= htmlspecialchars($row['month']) ?></td>
            <td><?= htmlspecialchars($row['category_name'] ?? '-') ?></td>
            <td><?= htmlspecialchars($row['menu_name']) ?></td>
            <td><?= $row['total_quantity'] ?></td>
            <td><?= number_format($row['total_sales']) ?></td>
        </tr>
        <?php endforeach; ?>
    </table>

    <h3>Store-wide Daily Sales</h3>
    <table>
        <tr>
            <th>Date</th><th>Total Sales (AED)</th>
        </tr>
        <?php foreach ($shop_daily as $row): ?>
        <tr>
            <td><?= htmlspecialchars($row['date']) ?></td>
            <td><?= number_format($row['total_sales']) ?></td>
        </tr>
        <?php endforeach; ?>
    </table>

    <h3>Store-wide Monthly Sales</h3>
    <table>
        <tr>
            <th>Month</th><th>Total Sales (AED)</th>
        </tr>
        <?php foreach ($shop_monthly as $row): ?>
        <tr>
            <td><?= htmlspecialchars($row['month']) ?></td>
            <td><?= number_format($row['total_sales']) ?></td>
        </tr>
        <?php endforeach; ?>
    </table>

</div>
</body>
</html>
