<?php
session_start();
require_once 'db.php';

if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("Location: login.php");
    exit;
}

// ▼ お店全体：日別売上（orderitems基準）
$sql_shop_daily = "
    SELECT 
        DATE(oi.created_at) AS date,
        SUM(oi.subtotal) AS total_sales
    FROM orderitems oi
    JOIN menuitems m ON oi.menu_item_id = m.id
    GROUP BY DATE(oi.created_at)
    ORDER BY DATE(oi.created_at) DESC
";
$shop_daily = $pdo->query($sql_shop_daily)->fetchAll();

// ▼ お店全体：月別売上（orderitems基準）
$sql_shop_monthly = "
    SELECT 
        DATE_FORMAT(oi.created_at, '%Y-%m') AS month,
        SUM(oi.subtotal) AS total_sales
    FROM orderitems oi
    JOIN menuitems m ON oi.menu_item_id = m.id
    GROUP BY month
    ORDER BY month DESC
";
$shop_monthly = $pdo->query($sql_shop_monthly)->fetchAll();

// ▼ 合計計算
$total_shop_daily = array_sum(array_column($shop_daily, 'total_sales'));
$total_shop_monthly = array_sum(array_column($shop_monthly, 'total_sales'));
?>

<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="UTF-8">
    <title>Store-wide Sales (From Order Items)</title>
    <link rel="stylesheet" href="style.css">
    <style>
        .sales-container {
            max-width: 1000px;
            margin: auto;
            padding: 30px;
        }

        h2, h3 {
            text-align: center;
            margin-top: 40px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }

        th, td {
            padding: 10px;
            border: 1px solid #ccc;
            text-align: center;
        }

        th {
            background-color: #007BFF;
            color: white;
        }

        .btn {
            display: inline-block;
            background-color: #4CAF50;
            color: white;
            padding: 8px 15px;
            border: none;
            border-radius: 5px;
            text-decoration: none;
            margin-bottom: 20px;
        }

        .btn:hover {
            background-color: #388e3c;
        }
    </style>
</head>
<body>
<div class="sales-container">

    <h2>Store-wide Sales (From Order Items)</h2>
    <a href="sales_report.php" class="btn">← Back to Sales Report</a>
    <a href="export_shop_csv.php" class="csv_btn">Download Store Sales CSV</a>

    <h3>🏪 Daily Store Sales</h3>
    <table>
        <tr>
            <th>Date</th><th>Total Sales (AED)</th>
        </tr>
        <?php foreach ($shop_daily as $row): ?>
        <tr>
            <td><?= htmlspecialchars($row['date']) ?></td>
            <td><?= number_format($row['total_sales']) ?></td>
        </tr>
        <?php endforeach; ?>
        <tr style="background-color: #f1f1f1; font-weight: bold;">
            <td>Daily Sales Total</td>
            <td><?= number_format($total_shop_daily) ?> AED</td>
        </tr>
    </table>

    <h3>📆 Monthly Store Sales</h3>
    <table>
        <tr>
            <th>Month</th><th>Total Sales (AED)</th>
        </tr>
        <?php foreach ($shop_monthly as $row): ?>
        <tr>
            <td><?= htmlspecialchars($row['month']) ?></td>
            <td><?= number_format($row['total_sales']) ?></td>
        </tr>
        <?php endforeach; ?>
        <tr style="background-color: #f1f1f1; font-weight: bold;">
            <td>Monthly Sales Total</td>
            <td><?= number_format($total_shop_monthly) ?> AED</td>
        </tr>
    </table>
</div>
</body>
</html>
